
require 'sketchup.rb'
require 'Phlatboyz/Constants.rb'
require 'Phlatboyz/PhlatTool.rb'
require 'Phlatboyz/tools/CenterLineTool.rb'
require 'Phlatboyz/Tools/FoldCut.rb'

module PhlatScript

  class FoldTool < CenterLineTool
    @@wide_cut = false
    
    def onLButtonUp(flags, x, y, view)
      edges = view.model.selection
      cuts = FoldCut.cut(edges, @@wide_cut)
      cuts.each { |cut| cut.cut_factor = compute_fold_depth_factor }
      view.model.selection.clear
      view.lock_inference
    end

    def onKeyDown(key, repeat, flags, view)
      if key == 87 # W key
        @@wide_cut = !@@wide_cut
        self.compute_fold_depth_factor()
        PhlatScript.display_fold_depth_factor()
        view.invalidate
      else
        super
      end
    end

    def draw(view)
      FoldCut.preview(view, collect_edges(@ip.edge), @@wide_cut) if !@ip.edge.nil?
    end

    def cut_class
      return FoldCut
    end

    def statusText
      return "#{super} W to toggle wide mode"
    end

  end

end